﻿/***************************************************************************/
/**                                                                       **/
/**                               MAGICARD                                **/
/**                                                                       **/
/***************************************************************************/
/**                                                                       **/
/**  PROJECT      : SDK C# Demo - Ultima Printers                         **/
/**                                                                       **/
/**  MODULE NAME  : HoloKotePreview.cs                                    **/
/**                                                                       **/
/**  COPYRIGHT    : Magicard                                              **/
/**                                                                       **/
/***************************************************************************/
using System;
using System.Drawing;
using System.Windows.Forms;

namespace CSharpDemo
{
	public partial class HKPreview: Form
	{
        private static Bitmap[] displayBuff = new Bitmap[1];

        public HKPreview(Bitmap[] buff, int count)
		{
            InitializeComponent();

            Array.Resize<Bitmap>(ref displayBuff, count);
            Array.Copy(buff, displayBuff, count);
            slotNumber.Value   = 1;
            slotNumber.Maximum = count;

            pictureBox.Image = displayBuff[0];
        }

        private void slotNumber_ValueChanged(object sender, EventArgs e)
        {
            pictureBox.Image = displayBuff[decimal.ToInt32(slotNumber.Value) - 1];
        }
	}
}
